


  function initPackageBuy(){
    const pkg = { name:"Pro Package", days:30 };
    const activeUntilEl = document.querySelector("[data-fp='pkg-until']");
    const countdownEl = document.querySelector("[data-fp='pkg-countdown']");
    const statusEl = document.querySelector("[data-fp='pkg-status']");
    const buyBtn = document.querySelector("[data-fp='pkg-buy']");
    const renewBtn = document.querySelector("[data-fp='pkg-renew']");

    const load = () => Number(localStorage.getItem("fp_pkg_until") || "0");
    const save = (until) => localStorage.setItem("fp_pkg_until", String(until));

    function fmtCountdown(ms){
      if(ms <= 0) return "Expired";
      const sec = Math.floor(ms/1000);
      const d = Math.floor(sec/86400);
      const h = Math.floor((sec%86400)/3600);
      const m = Math.floor((sec%3600)/60);
      const s = sec%60;
      return `${d}d ${h}h ${m}m ${s}s`;
    }

    function render(){
      const until = load();
      const now = Date.now();
      const active = until > now;
      if(activeUntilEl) activeUntilEl.textContent = until ? fmtDate(new Date(until)) : "—";
      if(statusEl){
        statusEl.innerHTML = active
          ? `<span class="px-2.5 py-1 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-700 dark:bg-emerald-500/10 dark:text-emerald-300">Active</span>`
          : `<span class="px-2.5 py-1 rounded-full text-xs font-semibold bg-slate-100 text-slate-700 dark:bg-white/5 dark:text-slate-200">Inactive</span>`;
      }
      if(countdownEl) countdownEl.textContent = until ? fmtCountdown(until - now) : "No package";
      if(buyBtn) buyBtn.classList.toggle("hidden", active);
      if(renewBtn) renewBtn.classList.toggle("hidden", !active);
    }

    let timer = null;
    function startTimer(){
      clearInterval(timer);
      timer = setInterval(render, 1000);
    }

    async function activate(days){
      const ok = await confirmModal({
        title: "Confirm Package Purchase",
        message: `Activate “${pkg.name}” for ${days} days? (Frontend demo)`,
        okText: "Activate",
        cancelText: "Cancel"
      });
      if(!ok) return;
      save(Date.now() + days*86400*1000);
      toast({type:"success", title:"Package Activated", message:`${pkg.name} is active for ${days} days.`});
      render();
      startTimer();
    }

    if(buyBtn) buyBtn.addEventListener("click", () => activate(pkg.days));
    if(renewBtn) renewBtn.addEventListener("click", () => activate(pkg.days));

    render();
    startTimer();
  }
